<?php
header("Content-Type: application/json");

require 'db.php'; // Ensure this connects correctly to your database

// Read and decode JSON input
$data = json_decode(file_get_contents("php://input"), true);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

if (!$data) {
    echo json_encode(["status" => "error", "message" => "Invalid or missing JSON payload"]);
    exit;
}

// Ensure `customerid` is provided for the update
if (!isset($data['id']) || empty($data['id'])) {
    echo json_encode(["status" => "error", "message" => "Customer ID is required for update"]);
    exit;
}

$customerid = mysqli_real_escape_string($conn, $data['id']);

// Initialize arrays to hold the update fields and values
$customer_updates = [];
$shipping_updates = [];

// Check and add each field to the update arrays if it is set in the data
if (isset($data['type']) && !empty($data['type'])) $customer_updates[] = "customertype = '" . mysqli_real_escape_string($conn, $data['type']) . "'";
if (isset($data['primarycontact']) && !empty($data['primarycontact'])) $customer_updates[] = "primarycontact = '" . mysqli_real_escape_string($conn, $data['primarycontact']) . "'";
if (isset($data['phonenumber']) && !empty($data['phonenumber'])) $customer_updates[] = "phonenumber = '" . mysqli_real_escape_string($conn, $data['phonenumber']) . "'";
if (isset($data['companyname']) && !empty($data['companyname'])) $customer_updates[] = "companyname = '" . mysqli_real_escape_string($conn, $data['companyname']) . "'";
if (isset($data['displayname']) && !empty($data['displayname'])) $customer_updates[] = "displayname = '" . mysqli_real_escape_string($conn, $data['displayname']) . "'";
if (isset($data['name']) && !empty($data['name'])) $customer_updates[] = "name1 = '" . mysqli_real_escape_string($conn, $data['name']) . "'";
if (isset($data['email']) && !empty($data['email'])) $customer_updates[] = "email = '" . mysqli_real_escape_string($conn, $data['email']) . "'";
if (isset($data['phoneno']) && !empty($data['phoneno'])) $customer_updates[] = "phoneno = '" . mysqli_real_escape_string($conn, $data['phoneno']) . "'";
if (isset($data['address']) && !empty($data['address'])) $customer_updates[] = "address = '" . mysqli_real_escape_string($conn, $data['address']) . "'";
if (isset($data['city']) && !empty($data['city'])) $customer_updates[] = "city = '" . mysqli_real_escape_string($conn, $data['city']) . "'";
if (isset($data['sstateid']) && !empty($data['sstateid'])) $customer_updates[] = "sstate = '" . mysqli_real_escape_string($conn, $data['sstateid']) . "'";
if (isset($data['state']) && !empty($data['state'])) $customer_updates[] = "state = '" . mysqli_real_escape_string($conn, $data['state']) . "'";
if (isset($data['pincode']) && !empty($data['pincode'])) $customer_updates[] = "pincode = '" . mysqli_real_escape_string($conn, $data['pincode']) . "'";
if (isset($data['referralcode']) && !empty($data['referralcode'])) $customer_updates[] = "referralcode = '" . mysqli_real_escape_string($conn, $data['referralcode']) . "'";
if (isset($data['gstno']) && !empty($data['gstno'])) $customer_updates[] = "gstno = '" . mysqli_real_escape_string($conn, $data['gstno']) . "'";
if (isset($data['website']) && !empty($data['website'])) $customer_updates[] = "website = '" . mysqli_real_escape_string($conn, $data['website']) . "'";
if (isset($data['currency']) && !empty($data['currency'])) $customer_updates[] = "currency = '" . mysqli_real_escape_string($conn, $data['currency']) . "'";
if (isset($data['paymentterms']) && !empty($data['paymentterms'])) $customer_updates[] = "paymentterms = '" . mysqli_real_escape_string($conn, $data['paymentterms']) . "'";
if (isset($data['advance']) && !empty($data['advance'])) $customer_updates[] = "advance = '" . mysqli_real_escape_string($conn, $data['advance']) . "'";
if (isset($data['due']) && !empty($data['due'])) $customer_updates[] = "due = '" . mysqli_real_escape_string($conn, $data['due']) . "'";
if (isset($data['amount']) && !empty($data['amount'])) $customer_updates[] = "amount = '" . mysqli_real_escape_string($conn, $data['amount']) . "'";
if (isset($data['invoice']) && !empty($data['invoice'])) $customer_updates[] = "invoice = '" . mysqli_real_escape_string($conn, $data['invoice']) . "'";
if (isset($data['description']) && !empty($data['description'])) $customer_updates[] = "description = '" . mysqli_real_escape_string($conn, $data['description']) . "'";
if (isset($data['paymenttype']) && !empty($data['paymenttype'])) $customer_updates[] = "paymenttype = '" . mysqli_real_escape_string($conn, $data['paymenttype']) . "'";
if (isset($data['givendate']) && !empty($data['givendate'])) $customer_updates[] = "givendate = '" . mysqli_real_escape_string($conn, $data['givendate']) . "'";
if (isset($data['receiveddate']) && !empty($data['receiveddate'])) $customer_updates[] = "receiveddate = '" . mysqli_real_escape_string($conn, $data['receiveddate']) . "'";
if (isset($data['currentdate']) && !empty($data['currentdate'])) $customer_updates[] = "currentdate = '" . mysqli_real_escape_string($conn, $data['currentdate']) . "'";
if (isset($data['status']) && !empty($data['status'])) $customer_updates[] = "status = '" . mysqli_real_escape_string($conn, $data['status']) . "'";
if (isset($data['dueadvancestatus']) && !empty($data['dueadvancestatus'])) $customer_updates[] = "dueadvancestatus = '" . mysqli_real_escape_string($conn, $data['dueadvancestatus']) . "'";
if (isset($data['blockcash']) && !empty($data['blockcash'])) $customer_updates[] = "blockcash = '" . mysqli_real_escape_string($conn, $data['blockcash']) . "'";
if (isset($data['hasGST']) && !empty($data['hasGST'])) $customer_updates[] = "hasGST = '" . mysqli_real_escape_string($conn, $data['hasGST']) . "'";

if (isset($data['sname']) && !empty($data['sname'])) $shipping_updates[] = "sname = '" . mysqli_real_escape_string($conn, $data['sname']) . "'";
if (isset($data['sphonenumber']) && !empty($data['sphonenumber'])) $shipping_updates[] = "sphonenumber = '" . mysqli_real_escape_string($conn, $data['sphonenumber']) . "'";
if (isset($data['saddress']) && !empty($data['saddress'])) $shipping_updates[] = "saddress = '" . mysqli_real_escape_string($conn, $data['saddress']) . "'";
if (isset($data['spincode']) && !empty($data['spincode'])) $shipping_updates[] = "spincode = '" . mysqli_real_escape_string($conn, $data['spincode']) . "'";
if (isset($data['scity']) && !empty($data['scity'])) $shipping_updates[] = "scity = '" . mysqli_real_escape_string($conn, $data['scity']) . "'";
if (isset($data['sstateid']) && !empty($data['sstateid'])) $shipping_updates[] = "sstateid = '" . mysqli_real_escape_string($conn, $data['sstateid']) . "'";

// Build the SQL query for customer table
if (!empty($customer_updates)) {
    $sql_customer = "UPDATE customer SET " . implode(", ", $customer_updates) . " WHERE id = '$customerid'";
    if (!mysqli_query($conn, $sql_customer)) {
        echo json_encode(["status" => "error", "message" => "Failed to update customer data", "error_detail" => mysqli_error($conn)]);
        mysqli_close($conn);
        exit;
    }
}

// Build the SQL query for customershipping table
if (!empty($shipping_updates)) {
    $sql_shipping = "UPDATE customershipping SET " . implode(", ", $shipping_updates) . " WHERE customerid = '$customerid'";
    if (!mysqli_query($conn, $sql_shipping)) {
        echo json_encode(["status" => "error", "message" => "Failed to update shipping data", "error_detail" => mysqli_error($conn)]);
        mysqli_close($conn);
        exit;
    }
}

// Function to check if a record already exists in the address table
function recordExists($conn, $customerid, $displayname, $phonenumber, $address, $city, $state, $pincode) {
    $query = "SELECT * FROM address 
              WHERE customerid = '$customerid' 
              AND customername = '$displayname' 
              AND phonenumber = '$phonenumber' 
              AND address = '$address' 
              AND city = '$city' 
              AND state = '$state' 
              AND pincode = '$pincode'";
    $result = mysqli_query($conn, $query);
    return mysqli_num_rows($result) > 0;
}

// Insert into address table only if the required fields are not empty and the record does not already exist
if (!empty($data['displayname']) && !empty($data['phonenumber']) && !empty($data['address']) && !empty($data['city']) && !empty($data['state']) && !empty($data['pincode'])) {
    $displayname = mysqli_real_escape_string($conn, $data['displayname']);
    $phonenumber = mysqli_real_escape_string($conn, $data['phonenumber']);
    $address = mysqli_real_escape_string($conn, $data['address']);
    $city = mysqli_real_escape_string($conn, $data['city']);
    $state = mysqli_real_escape_string($conn, $data['state']);
    $pincode = mysqli_real_escape_string($conn, $data['pincode']);

    if (!recordExists($conn, $customerid, $displayname, $phonenumber, $address, $city, $state, $pincode)) {
        $insert_query = "INSERT INTO address (customerid, customername, phonenumber, address, city, state, pincode) 
                         VALUES ('$customerid', '$displayname', '$phonenumber', '$address', '$city', '$state', '$pincode')";
        if (!mysqli_query($conn, $insert_query)) {
            echo json_encode(["status" => "error", "message" => "Failed to insert into address table", "error_detail" => mysqli_error($conn)]);
            mysqli_close($conn);
            exit;
        }
    }
}

// Insert into address table for shipping address only if the required fields are not empty and the record does not already exist
if (!empty($data['sname']) && !empty($data['sphonenumber']) && !empty($data['saddress']) && !empty($data['scity']) && !empty($data['sstateid']) && !empty($data['spincode'])) {
    $sname = mysqli_real_escape_string($conn, $data['sname']);
    $sphonenumber = mysqli_real_escape_string($conn, $data['sphonenumber']);
    $saddress = mysqli_real_escape_string($conn, $data['saddress']);
    $scity = mysqli_real_escape_string($conn, $data['scity']);
    $sstateid = mysqli_real_escape_string($conn, $data['sstateid']);
    $spincode = mysqli_real_escape_string($conn, $data['spincode']);

    if (!recordExists($conn, $customerid, $sname, $sphonenumber, $saddress, $scity, $sstateid, $spincode)) {
        $insert_query1 = "INSERT INTO address (customerid, customername, phonenumber, address, city, state, pincode) 
                          VALUES ('$customerid', '$sname', '$sphonenumber', '$saddress', '$scity', '$sstateid', '$spincode')";
        if (!mysqli_query($conn, $insert_query1)) {
            echo json_encode(["status" => "error", "message" => "Failed to insert into address table", "error_detail" => mysqli_error($conn)]);
            mysqli_close($conn);
            exit;
        }
    }
}

// Success response
echo json_encode(["status" => "success", "message" => "Customer and shipping details updated successfully"]);
mysqli_close($conn);
?>